param(
    [string]$clinic,
    [int]$number
)

# تحويل كود العيادة إلى اسم عربي
switch ($clinic) {
    "ortho"   { $clinicName = "عيادة العظام" }
    "derma"   { $clinicName = "عيادة الجلدية" }
    "gyn"     { $clinicName = "عيادة النساء" }
    "ent"     { $clinicName = "عيادة الأنف والأذن والحنجرة" }
    "ped"     { $clinicName = "عيادة الأطفال" }
    "int"     { $clinicName = "عيادة الباطنية" }
    "uro"     { $clinicName = "عيادة المسالك البولية" }
    "cardio"  { $clinicName = "عيادة القلب" }
    Default   { $clinicName = "العيادة" }
}

$text = "الرجاء التوجه إلى $clinicName رقم $number"

Add-Type -AssemblyName System.Speech
$s = New-Object System.Speech.Synthesis.SpeechSynthesizer
$s.SelectVoice("Microsoft Naayf")
$s.Rate = 0
$s.Speak($text)
