<?php
// display_all.php — لوغو داخل كل عيادة + لوغو أعلى الشاشة

$host    = 'localhost';
$db      = 'queue_system';
$user    = 'root';
$pass    = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (Exception $e) {
    die('خطأ في الاتصال بقاعدة البيانات');
}

$sql = "SELECT id, name_ar FROM services WHERE is_active = 1 ORDER BY id ASC";
$stmt = $pdo->query($sql);
$services = $stmt->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>شاشة جميع العيادات</title>

<style>
body{
    margin:0;
    background:#ffffff;
    color:#0f172a;
    font-family: Tahoma, Arial, sans-serif;
    text-align:center;
}

/* ———————————— العنوان ———————————— */
.header{
    padding:14px 10px 10px;
}
.header img{
    max-width:200px;
    margin-bottom:6px;
}
.header-title{
    font-size:22px;
    color:#334155;
    font-weight:bold;
}

/* ———————————— الشبكة ———————————— */
.main{
    padding:10px 20px 30px;
}

.clinics-grid{
    display:flex;
    flex-wrap:wrap;
    gap:18px;
    justify-content:center;
}

/* ———————————— بطاقة العيادة ———————————— */
.clinic-card{
    position:relative;
    background:#ffffff;
    border-radius:16px;
    padding:16px 14px 18px;
    border:1px solid #e2e8f0;
    box-shadow:0 8px 20px rgba(0,0,0,.04);
    width:260px;
    box-sizing:border-box;
    overflow:hidden;
}

/* 🔵 اللوغو داخل البطاقة (ووترمارك) */
.clinic-card::before{
    content:"";
    position:absolute;
    inset:0;
    background:url("images/logo.png") no-repeat center center;
    background-size:55%;
    opacity:.18;
    pointer-events:none;
    z-index:0;
}

.clinic-name{
    position:relative;
    z-index:2;
    font-size:20px;
    margin-bottom:10px;
    color:#0f172a;
}

.ticket-code{
    position:relative;
    z-index:2;
    font-size:60px;
    font-weight:bold;
    margin:4px 0 12px;
}

/* الحالات */
.ticket-wait{ color:#1d4ed8; }
.ticket-serving{ color:#dc2626; }

/* حركة قبل الدخول */
@keyframes pulseMove {
    0%{transform:scale(1);}
    50%{transform:scale(1.06);}
    100%{transform:scale(1);}
}
.animate-number{
    animation:pulseMove 1.2s ease-in-out infinite;
}

.sep{
    position:relative;
    z-index:2;
    height:1px;
    background:#e5e7eb;
    margin:6px auto 8px;
    width:90%;
}

.msg{
    position:relative;
    z-index:2;
    font-size:14px;
    color:#1e3a8a;
    min-height:20px;
}
</style>

<meta http-equiv="refresh" content="5">

</head>
<body>

<div class="header">
    <!-- 🔼 اللوغو أعلى الصفحة -->
    <img src="images/logo.png" alt="Logo">

    <div class="header-title">
         مستشفى احمد محمد
    </div>
</div>

<div class="main">
    <div class="clinics-grid">

        <?php if (!$services): ?>
            لا توجد عيادات مفعّلة
        <?php else: ?>
            <?php foreach ($services as $srv): ?>

                <?php
                $sqlT = "
                    SELECT full_code, served_at
                    FROM tickets
                    WHERE service_id = ?
                      AND status = 'called'
                    ORDER BY called_at DESC, id DESC
                    LIMIT 1
                ";
                $stT = $pdo->prepare($sqlT);
                $stT->execute([$srv['id']]);
                $ticket = $stT->fetch();

                $code   = '—';
                $msg    = 'لا يوجد مريض منادى حالياً';
                $cls    = 'ticket-code ticket-wait';

                if ($ticket) {
                    $code = $ticket['full_code'];

                    $served = $ticket['served_at'] ?? null;
                    $isEmpty =
                        ($served === null) ||
                        ($served === '') ||
                        ($served === '0000-00-00 00:00:00');

                    if ($isEmpty) {
                        $msg = 'يرجى التوجّه إلى العيادة';
                        $cls = 'ticket-code ticket-wait animate-number';
                    } else {
                        $msg = 'يتم الآن فحص المريض داخل العيادة';
                        $cls = 'ticket-code ticket-serving';
                    }
                }
                ?>

                <div class="clinic-card">
                    <div class="clinic-name"><?= htmlspecialchars($srv['name_ar']) ?></div>

                    <div class="<?= $cls ?>">
                        <?= htmlspecialchars($code) ?>
                    </div>

                    <div class="sep"></div>

                    <div class="msg"><?= htmlspecialchars($msg) ?></div>
                </div>

            <?php endforeach; ?>
        <?php endif; ?>

    </div>
</div>

</body>
</html>
