<?php
// display_single.php — شاشة عيادة واحدة (أزرق متحرك — أحمر متوقف عند بدء المعاينة)

$host = 'localhost';
$db   = 'queue_system';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (Exception $e) {
    die('خطأ في الاتصال بقاعدة البيانات');
}

$serviceId = isset($_GET['service_id']) ? (int)$_GET['service_id'] : 0;
if ($serviceId <= 0) {
    die('service_id مفقود في الرابط مثل: display_single.php?service_id=1');
}

// جلب بيانات العيادة
$stmt = $pdo->prepare("SELECT * FROM services WHERE id = ? AND is_active = 1");
$stmt->execute([$serviceId]);
$service = $stmt->fetch();
if (!$service) {
    die('العيادة غير موجودة أو غير مفعّلة.');
}

// AJAX: يرجع آخر تذكرة بحالة called
if (isset($_GET['ajax']) && $_GET['ajax'] == '1') {
    header('Content-Type: application/json; charset=utf-8');

    $sql = "
        SELECT full_code, file_number, served_at
        FROM tickets
        WHERE service_id = ?
          AND status = 'called'
        ORDER BY called_at DESC, id DESC
        LIMIT 1
    ";
    $s = $pdo->prepare($sql);
    $s->execute([$serviceId]);
    $row = $s->fetch();

    echo json_encode($row ?: []);
    exit;
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>شاشة عيادة — <?= htmlspecialchars($service['name_ar']) ?></title>

<style>
body{
    margin:0;
    background:#ffffff;
    color:#0f172a;
    font-family: Tahoma, Arial, sans-serif;
    text-align:center;
}

/* الهيدر مع الشعار */
.header{ padding:16px 12px 6px; }
.header img{ max-width:200px; }
.header-title{ margin-top:6px; font-size:20px; color:#334155; }

/* المساحة الرئيسية */
.main{
    display:flex;
    justify-content:center;
    align-items:center;
    min-height:calc(100vh - 120px);
    padding:10px 15px 25px;
}

/* الكرت */
.box{
    background:#ffffff;
    border-radius:16px;
    padding:28px 26px;
    border:1px solid #e2e8f0;
    box-shadow:0 10px 26px rgba(0,0,0,.05);
    max-width:520px;
    width:100%;
}

.clinic-name{ font-size:26px; margin-bottom:14px; }

/* الرقم */
.ticket-code{
    font-size:100px;
    font-weight:bold;
    margin:6px 0 12px;
}

/* ——— الحالات ——— */

/* المريض منادى ولم يدخل: أزرق + حركة */
.ticket-wait{ color:#1d4ed8; }

/* حركة خفيفة */
@keyframes pulseMove {
    0%   { transform: scale(1); }
    50%  { transform: scale(1.06); }
    100% { transform: scale(1); }
}
.animate-number{
    animation: pulseMove 1.2s ease-in-out infinite;
}

/* المريض داخل العيادة: أحمر — بدون حركة */
.ticket-serving{ color:#dc2626; }

.file-number{ font-size:22px; color:#334155; margin-bottom:10px; }
.sep{ height:1px; background:#e5e7eb; margin:14px auto; width:85%; }
.msg{ font-size:20px; color:#1e3a8a; }
</style>
</head>

<body>

<div class="header">
    <img src="images/logo.png" alt="Logo">
    <div class="header-title">
        شاشة عيادة: <?= htmlspecialchars($service['name_ar']) ?>
    </div>
</div>

<div class="main">
    <div class="box">
        <div class="clinic-name"><?= htmlspecialchars($service['name_ar']) ?></div>

        <div class="ticket-code ticket-wait" id="code">—</div>
        <div class="file-number" id="file">رقم الملف: —</div>

        <div class="sep"></div>
        <div class="msg" id="msg">لا يوجد مريض منادى حالياً</div>
    </div>
</div>

<script>
// تحديث بدون ريفرش — يدعم أندرويد القديم
function loadData(){
    var xhr = new XMLHttpRequest();
    xhr.open('GET', 'display_single.php?ajax=1&service_id=<?= (int)$serviceId ?>', true);

    xhr.onreadystatechange = function(){
        if (xhr.readyState === 4 && xhr.status === 200) {
            var data = {};
            try { data = JSON.parse(xhr.responseText || '{}'); }
            catch(e){ data = {}; }

            var codeEl = document.getElementById('code');
            var fileEl = document.getElementById('file');
            var msgEl  = document.getElementById('msg');

            if (!data || !data.full_code) {
                codeEl.textContent = '—';
                fileEl.textContent = 'رقم الملف: —';
                msgEl.textContent  = 'لا يوجد مريض منادى حالياً';

                codeEl.className = 'ticket-code ticket-wait';
                return;
            }

            codeEl.textContent = data.full_code;
            fileEl.textContent = 'رقم الملف: ' + (data.file_number || 'غير مسجّل');

            var served = data.served_at;
            var isEmptyServed =
                (served === null) ||
                (served === '') ||
                (served === '0000-00-00 00:00:00');

            if (isEmptyServed) {
                // خارج العيادة — أزرق + حركة
                msgEl.textContent = 'يرجى التوجّه إلى العيادة';
                codeEl.className = 'ticket-code ticket-wait animate-number';
            } else {
                // داخل العيادة — أحمر + بدون حركة
                msgEl.textContent = 'يتم الآن فحص المريض داخل العيادة';
                codeEl.className = 'ticket-code ticket-serving';
            }
        }
    };

    xhr.send();
}

loadData();
setInterval(loadData, 4000);
</script>

</body>
</html>
