<?php
// patients_add.php — إدخال بيانات المرضى مع توليد رقم ملف تلقائي + رقم هوية

$host    = 'localhost';
$db      = 'queue_system';
$user    = 'root';
$pass    = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (Exception $e) {
    die('خطأ في الاتصال بقاعدة البيانات');
}

$successMsg = "";
$errorMsg   = "";

// إنشاء جدول المرضى إذا لم يكن موجوداً
$pdo->exec("
CREATE TABLE IF NOT EXISTS patients (
  id INT AUTO_INCREMENT PRIMARY KEY,
  file_number VARCHAR(50) NOT NULL UNIQUE,
  national_id VARCHAR(20) NOT NULL,
  full_name   VARCHAR(150) NOT NULL,
  mobile      VARCHAR(20),
  dob         DATE,
  gender      ENUM('M','F') NULL,
  notes       TEXT,
  created_at  TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

// محاولة إضافة حقل national_id إذا كان الجدول موجوداً من قبل بدون هذا الحقل
try {
    $pdo->exec("ALTER TABLE patients ADD COLUMN national_id VARCHAR(20) NOT NULL AFTER file_number");
    $pdo->exec("ALTER TABLE patients ADD UNIQUE KEY uniq_national_id (national_id)");
} catch (Exception $e) {
    // إذا كان الحقل موجوداً مسبقاً نتجاهل الخطأ
}

// دالة تجيب رقم الملف التالي تلقائياً
function getNextFileNumber(PDO $pdo): int
{
    $sql  = "SELECT MAX(CAST(file_number AS UNSIGNED)) AS max_file FROM patients";
    $stmt = $pdo->query($sql);
    $row  = $stmt->fetch();

    if (!empty($row['max_file'])) {
        return (int)$row['max_file'] + 1;
    }
    // أول مريض: ابدأ من 100000 (تقدر تغيرها)
    return 100000;
}

$file_number = '';
$full_name   = '';
$mobile      = '';
$dob         = '';
$gender      = '';
$notes       = '';
$national_id = '';

// رقم الملف الافتراضي أول مرة
$generatedFileNumber = getNextFileNumber($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // رقم الملف يقرأ من hidden ولا يكتبه الموظف
    $file_number = trim($_POST['file_number'] ?? '');
    if ($file_number === '') {
        $file_number = (string)getNextFileNumber($pdo);
    }

    $national_id = trim($_POST['national_id'] ?? '');
    $full_name   = trim($_POST['full_name']   ?? '');
    $mobile      = trim($_POST['mobile']      ?? '');
    $dob         = trim($_POST['dob']         ?? '');
    $gender      = trim($_POST['gender']      ?? '');
    $notes       = trim($_POST['notes']       ?? '');

    if ($full_name === '' || $national_id === '') {
        $errorMsg = "رقم الهوية والاسم الكامل حقول إلزامية.";
        // نظهر نفس رقم الملف الذي كان في الطلب
        $generatedFileNumber = (int)$file_number;
    } else {
        // التأكد من عدم تكرار رقم الهوية
        $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM patients WHERE national_id = ?");
        $stmt->execute([$national_id]);
        $existsId = (int)$stmt->fetch()['c'] > 0;

        if ($existsId) {
            $errorMsg = "رقم الهوية مسجل سابقاً لمريض آخر.";
            $generatedFileNumber = (int)$file_number;
        } else {
            // التأكد من عدم تكرار رقم الملف
            $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM patients WHERE file_number = ?");
            $stmt->execute([$file_number]);
            $existsFile = (int)$stmt->fetch()['c'] > 0;

            if ($existsFile) {
                $errorMsg = "رقم الملف مستخدم سابقاً، أعد المحاولة.";
                $generatedFileNumber = getNextFileNumber($pdo);
                $file_number = (string)$generatedFileNumber;
            } else {
                $sql = "
                    INSERT INTO patients (file_number, national_id, full_name, mobile, dob, gender, notes)
                    VALUES (?, ?, ?, ?, ?, ?, ?)
                ";
                $stmt = $pdo->prepare($sql);
                $stmt->execute([
                    $file_number,
                    $national_id,
                    $full_name,
                    $mobile !== '' ? $mobile : null,
                    $dob   !== '' ? $dob    : null,
                    $gender !== '' ? $gender : null,
                    $notes !== '' ? $notes  : null,
                ]);

                $successMsg = "✅ تم حفظ بيانات المريض بنجاح.";
                // تفريغ الحقول بعد الحفظ
                $full_name   = '';
                $mobile      = '';
                $dob         = '';
                $gender      = '';
                $notes       = '';
                $national_id = '';
                // توليد رقم ملف جديد للمريض التالي
                $generatedFileNumber = getNextFileNumber($pdo);
                $file_number = (string)$generatedFileNumber;
            }
        }
    }
} else {
    // أول فتح للصفحة: نعين رقم الملف المولّد
    $file_number = (string)$generatedFileNumber;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدخال بيانات المرضى</title>
<style>
    body{
        font-family: Tahoma, Arial, sans-serif;
        background:#f4f4f5;
        margin:0;
        padding:0;
        color:#0f172a;
    }
    .wrapper{
        max-width:600px;
        margin:30px auto;
        padding:0 15px 30px;
    }
    .logo{
        text-align:center;
        margin-bottom:10px;
    }
    .logo img{
        max-width:180px;
    }
    h1{
        text-align:center;
        margin:5px 0 20px;
        font-size:22px;
    }
    .card{
        background:#ffffff;
        border-radius:12px;
        padding:20px 18px 22px;
        box-shadow:0 8px 20px rgba(0,0,0,0.05);
        border:1px solid #e5e7eb;
    }
    label{
        display:block;
        font-size:14px;
        margin-top:8px;
        margin-bottom:3px;
    }
    input, select, textarea{
        width:100%;
        box-sizing:border-box;
        padding:8px 10px;
        border-radius:8px;
        border:1px solid #cbd5e1;
        font-size:14px;
    }
    textarea{
        resize:vertical;
    }
    .row{
        display:flex;
        gap:10px;
    }
    .row > div{
        flex:1;
    }
    button{
        margin-top:12px;
        width:100%;
        padding:10px;
        border:none;
        border-radius:999px;
        background:linear-gradient(135deg,#bfdbfe,#60a5fa);
        color:#0f172a;
        font-size:16px;
        font-weight:bold;
        cursor:pointer;
    }
    button:active{
        transform:scale(.98);
    }
    .msg{
        margin-bottom:10px;
        padding:8px 10px;
        border-radius:8px;
        font-size:14px;
    }
    .msg.success{
        background:#ecfdf3;
        color:#166534;
        border:1px solid #bbf7d0;
    }
    .msg.error{
        background:#fef2f2;
        color:#b91c1c;
        border:1px solid #fecaca;
    }
    .top-links{
        text-align:center;
        margin-bottom:10px;
        font-size:13px;
    }
    .top-links a{
        color:#2563eb;
        text-decoration:none;
        margin:0 4px;
    }
    .file-display{
        font-weight:bold;
        font-size:16px;
        color:#1d4ed8;
        padding:6px 10px;
        background:#eff6ff;
        border-radius:8px;
        border:1px solid #bfdbfe;
        display:inline-block;
        margin-top:2px;
    }
</style>
</head>
<body>
<div class="wrapper">

    <div class="logo">
        <!-- غيّر المسار حسب مكان الشعار عندك -->
        <img src="images/logo.png" alt="شعار">
    </div>

    <h1>إدخال بيانات مريض</h1>

    <div class="top-links">
        <a href="kiosk.php">الكشك</a> |
        <a href="dashboard.php">لوحة التحكم</a>
    </div>

    <div class="card">
        <?php if($successMsg): ?>
            <div class="msg success"><?= htmlspecialchars($successMsg) ?></div>
        <?php endif; ?>

        <?php if($errorMsg): ?>
            <div class="msg error"><?= htmlspecialchars($errorMsg) ?></div>
        <?php endif; ?>

        <form method="post">

            <label>رقم الملف (يتولد تلقائياً)</label>
            <div class="file-display">
                <?= htmlspecialchars($file_number) ?>
            </div>
            <input type="hidden" name="file_number" value="<?= htmlspecialchars($file_number) ?>">

            <label>رقم الهوية *</label>
            <input name="national_id" required value="<?= htmlspecialchars($national_id) ?>" placeholder="رقم الهوية">

            <label>الاسم الكامل *</label>
            <input name="full_name" required value="<?= htmlspecialchars($full_name) ?>" placeholder="الاسم الرباعي">

            <div class="row">
                <div>
                    <label>الجوال</label>
                    <input name="mobile" value="<?= htmlspecialchars($mobile) ?>" placeholder="05xxxxxxxx">
                </div>
                <div>
                    <label>تاريخ الميلاد</label>
                    <input type="date" name="dob" value="<?= htmlspecialchars($dob) ?>">
                </div>
            </div>

            <label>الجنس</label>
            <select name="gender">
                <option value="" <?= $gender === '' ? 'selected' : '' ?>>—</option>
                <option value="M" <?= $gender === 'M' ? 'selected' : '' ?>>ذكر</option>
                <option value="F" <?= $gender === 'F' ? 'selected' : '' ?>>أنثى</option>
            </select>

            <label>ملاحظات</label>
            <textarea name="notes" rows="3"><?= htmlspecialchars($notes) ?></textarea>

            <button type="submit">حفظ بيانات المريض</button>
        </form>
    </div>
</div>
</body>
</html>
